/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.block;

import java.util.Random;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.world.feature.EndPortalRunes;
import svenhjol.charm.world.message.MessagePortalInteract;
import svenhjol.charm.world.tile.TileRunePortal;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.iface.IMesonBlock;

public class BlockRunePortal
extends BlockEndPortal
implements IMesonBlock {
    public BlockRunePortal() {
        super(Material.field_151567_E);
        this.func_149752_b(6000000.0f);
        this.func_149711_c(-1.0f);
        this.func_149722_s();
        this.register(this.getName());
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public String getName() {
        return "rune_portal";
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return TileRunePortal.class;
    }

    public TileRunePortal getTileEntity(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileRunePortal) {
            return (TileRunePortal)tile;
        }
        return null;
    }

    public void setPortal(World world, BlockPos pos, BlockPos portal) {
        TileRunePortal tile = this.getTileEntity(world, pos);
        if (tile != null) {
            tile.portal = portal;
        }
    }

    public BlockPos getPortal(World world, BlockPos pos) {
        TileRunePortal tile = this.getTileEntity(world, pos);
        if (tile != null) {
            return tile.portal;
        }
        return null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileRunePortal();
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        BlockPos thisPortal;
        if (!worldIn.field_72995_K && !entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.func_184222_aU() && entityIn.func_174813_aQ().func_72326_a(state.func_185900_c((IBlockAccess)worldIn, pos).func_186670_a(pos)) && (thisPortal = this.getPortal(worldIn, pos)) != null) {
            BlockPos foundPortal = EndPortalRunes.findPortal(worldIn, thisPortal);
            if (entityIn instanceof EntityPlayer) {
                MessagePortalInteract message;
                EntityPlayer player = (EntityPlayer)entityIn;
                BlockPos teleportTo = foundPortal == null ? thisPortal : foundPortal;
                PlayerHelper.teleportPlayer(player, teleportTo.func_177982_a(-2, 1, 0), 0);
                if (foundPortal != null) {
                    message = new MessagePortalInteract(foundPortal, 2);
                } else {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 120, 4));
                    message = new MessagePortalInteract(thisPortal, 0);
                }
                NetworkHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
            } else {
                entityIn.func_70106_y();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        float f = rand.nextFloat();
        EnumParticleTypes particle = f < 0.5f ? EnumParticleTypes.ENCHANTMENT_TABLE : EnumParticleTypes.SMOKE_NORMAL;
        double d0 = (float)pos.func_177958_n() + rand.nextFloat();
        double d1 = (float)pos.func_177956_o() + 1.0f;
        double d2 = (float)pos.func_177952_p() + rand.nextFloat();
        worldIn.func_175688_a(particle, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }
}

